/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.InstrumentNotificationHandler;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotificationDispatcher
extends Thread {
    private Vector<InstrumentNotificationHandler> m_notHandlers;
    private boolean m_lcdUpdate = false;
    private boolean m_ledUpdate = false;
    private boolean m_active = true;
    private final String LCD_NOTIFICATION = "LCD-CHANGE";
    private final String LED_NOTIFICATION = "LED-CHANGE";

    public NotificationDispatcher(Vector<InstrumentNotificationHandler> handlers) {
        this.m_notHandlers = handlers;
        this.setDaemon(true);
    }

    public void dispatch(String notif) {
        if (notif.equals("LCD-CHANGE")) {
            this.m_lcdUpdate = true;
        } else if (notif.equals("LED-CHANGE")) {
            this.m_ledUpdate = true;
        }
    }

    public void deactivate() {
        this.m_active = false;
    }

    @Override
    public void run() {
        try {
            while (this.m_active) {
                InstrumentNotificationHandler handler;
                int i;
                if (this.m_lcdUpdate) {
                    this.m_lcdUpdate = false;
                    i = 0;
                    while (i < this.m_notHandlers.size()) {
                        handler = this.m_notHandlers.elementAt(i);
                        handler.handleInstrumentNotification("LCD-CHANGE");
                        ++i;
                    }
                }
                if (this.m_ledUpdate) {
                    this.m_ledUpdate = false;
                    i = 0;
                    while (i < this.m_notHandlers.size()) {
                        handler = this.m_notHandlers.elementAt(i);
                        handler.handleInstrumentNotification("LED-CHANGE");
                        ++i;
                    }
                }
                NotificationDispatcher.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

